package app.firezone.synk.network.Adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import app.firezone.synk.network.Activities.ClaasicWinnerActivity;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.ItemClassicResultBinding;
import app.firezone.synk.network.model.ResultModel;

import java.util.ArrayList;

public class ClassicResultAdapter extends RecyclerView.Adapter<ClassicResultAdapter.holder> {

    Context mContext;
    ArrayList<ResultModel> mlist = new ArrayList<>();

    public ClassicResultAdapter(ArrayList<ResultModel> mlist, Context mContext) {
        this.mContext = mContext;
       this.mlist =  mlist;
    }

    @NonNull
    @Override
    public holder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(mContext).inflate(R.layout.item_classic_result,parent,false);
        return new holder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull holder holder, @SuppressLint("RecyclerView") int position) {

        ResultModel list = mlist.get(position);

        holder.binding.matchnoR.setText(list.getMatchno());
        holder.binding.entryfeeR.setText(list.getEntryfee());
        holder.binding.timeTxt.setText(list.getTime());
        holder.binding.dateTxt.setText(list.getDate());
        holder.binding.prizepoolResults.setText(list.getPrizepool());
        holder.binding.matchMapR.setText(list.getMap());
        holder.binding.matchNameR.setText(list.getGamename());


        holder.binding.matchWatchBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                Intent browserIntent = new Intent(Intent.ACTION_VIEW);
                browserIntent.setData(Uri.parse(list.getVideourl()));
                mContext.startActivity(browserIntent);

            }
        });

        holder.binding.matchResultBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                Intent intent = new Intent(mContext, ClaasicWinnerActivity.class);
                intent.putExtra("matchid", list.getMatchid());
                intent.putExtra("gamename", list.getGamename());
                mContext.startActivity(intent);


            }
        });



    }

    @Override
    public int getItemCount() {
        return mlist.size();
    }

    public class holder extends RecyclerView.ViewHolder {


        ItemClassicResultBinding binding;

        public holder(@NonNull View itemView) {
            super(itemView);


            binding = ItemClassicResultBinding.bind(itemView);




        }
    }
}
